-- Generated by SceneGenEditor and loaded by scenegen_autogen.lua
local t = {
  __displayName="owlitzer_forest",
  biome="forest",
  creature_spawners={
    battlefield={
      {
        color={ brightness=0, hue=0, saturation=0,},
        prop="spawner_plant1",
        sole_occupant_radius=2.0,
      },
    },
    miniboss={
      {
        color={ brightness=0, hue=0, saturation=0,},
        prop="spawner_miniboss",
        sole_occupant_radius=2.0,
      },
    },
    perimeter={
      {
        color={ brightness=0, hue=0, saturation=0,},
        prop="spawner_owlforest_perimeter",
        sole_occupant_radius=1.7999999523163,
      },
    },
  },
  destructibles={
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=0, to=0,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0, to=0,},},
      },
      prop="destructible_owlrock_shorty",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=0, to=0,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0, to=0,},},
      },
      prop="destructible_owlrock_tall",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=1, to=1,},},
        near_boss={ easing="linear", likelihood={ from=0, to=0,},},
        start_run={ easing="linear", likelihood={ from=1, to=1,},},
      },
      prop="destructible_rock_shorty",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=1, to=1,},},
        near_boss={ easing="linear", likelihood={ from=0, to=0,},},
        start_run={ easing="linear", likelihood={ from=1, to=1,},},
      },
      prop="destructible_rock_tall",
    },
  },
  dungeon="owlitzer_forest",
  environments={
    {
      label="Default",
      lighting={
        ambient="D0B7D8FF",
        clifflightweight=0.46299999952316,
        clifframp="ramp_toni",
        cliffskirt="startingforest_cliffwrock",
        colorcube={
          boss="startingforest_owlitzer_midway_cc",
          entrance="startingforest_owlitzer_start_cc",
        },
        ground_shadow_strength=0.75,
        rimlightcolor="A6FFF8FF",
        rimlightpos={ 0.10000000149012, 40.0, 50.0,},
      },
      room_types={ "hype", "miniboss", "monster", "empty", "entrance", "boss", "insert",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0.010889292196007, 0.29127642512321, 0.48045954108238, 0.7405858039856,},
            { 0.079854809437387, 0.30783849954605, 0.29047110676765, 0.51046025753021,},
            { 0.13430127041742, 0.20620927214622, 0.20076678693295, 0.39330542087555,},
            { 0.21778584392015, 0.13345354795456, 0.16412948071957, 0.32217574119568,},
            { 0.3015873015873, 9.9999999747524e-07, 6.0349378827596e-07, 3.1512607279183e-07,},
          },
          entrance={
            { 0.016460905349794, 0.65492397546768, 0.4668020606041, 0.70531404018402,},
            { 0.067901234567901, 0.3125393986702, 0.39027246832848, 0.69565218687057,},
            { 0.12757201646091, 0.21588236168027, 0.27588235810399, 0.45274511426687,},
            { 0.21904761904762, 0.075684383511543, 0.10530006140471, 0.22705316543579,},
            { 0.2968253968254, 9.9999999747524e-07, 6.0349378827596e-07, 3.1512607279183e-07,},
          },
        },
        prop_fade_color="000000FF",
      },
      water={  },
    },
    {
      label="Shop Rooms",
      lighting={
        ambient="E8C8E7FF",
        clifflightweight=0.46299999952316,
        clifframp="ramp_toni",
        cliffskirt="startingforest_cliffwrock",
        colorcube={
          boss="startingforest_owlitzershop_midway_cc",
          entrance="startingforest_owlitzershop_start_cc",
        },
        ground_shadow_strength=0.75,
        rimlightcolor="B3AAFFFF",
        rimlightpos={ 0.10000000149012, 40, 50,},
      },
      room_types={ "powerupgrade", "potion", "ranger", "food", "mystery", "resource", "wanderer",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0.033807829181495, 0.419607847929, 0.33333334326744, 0.66274511814117,},
            { 0.088967971530249, 0.28703701496124, 0.24532550573349, 0.5131579041481,},
            { 0.15302491103203, 0.22516529262066, 0.19500231742859, 0.47807019948959,},
            { 0.22064056939502, 0.093333706259727, 0.089899964630604, 0.50883388519287,},
            {
              0.32386363636364,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
          entrance={
            { 0.048042704626335, 0.63769048452377, 0.43758395314217, 0.63934427499771,},
            { 0.11032028469751, 0.41834908723831, 0.33468827605247, 0.66393446922302,},
            { 0.18327402135231, 0.21588236168027, 0.27588235810399, 0.45274511426687,},
            { 0.22916666666667, 0.1294117718935, 0.16470588743687, 0.3098039329052,},
            {
              0.32386363636364,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
        },
        prop_fade_color="000000FF",
      },
      water={  },
    },
    {
      label="NPC Rooms",
      lighting={
        ambient="E8C8E7FF",
        clifflightweight=0.46299999952316,
        clifframp="ramp_toni",
        cliffskirt="startingforest_cliffwrock",
        colorcube={
          boss="startingforest_owlitzershop_midway_cc",
          entrance="startingforest_owlitzershop_start_cc",
        },
        ground_shadow_strength=0.75,
        rimlightcolor="B3AAFFFF",
        rimlightpos={ 0.10000000149012, 40, 50,},
      },
      room_types={ "quest",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0.011363636363636, 0.21506620943546, 0.44214823842049, 0.75438594818115,},
            { 0.083333333333333, 0.26647010445595, 0.24532550573349, 0.5131579041481,},
            { 0.14772727272727, 0.20300391316414, 0.19500231742859, 0.47807019948959,},
            { 0.22464898595944, 0.089899964630604, 0.15799526870251, 0.50883388519287,},
            {
              0.32386363636364,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
          entrance={
            { 0, 0.55691188573837, 0.40112918615341, 0.59863948822021,},
            { 0.071969696969697, 0.32156863808632, 0.41176471114159, 0.62745100259781,},
            { 0.16098484848485, 0.21588236168027, 0.27588235810399, 0.45274511426687,},
            { 0.22916666666667, 0.1294117718935, 0.16470588743687, 0.3098039329052,},
            {
              0.28395061728395,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
        },
        prop_fade_color="000000FF",
      },
      water={  },
    },
    {
      label="Market Room",
      lighting={
        ambient="C3BCE4FF",
        clifflightweight=0.46299999952316,
        clifframp="ramp_toni",
        cliffskirt="startingforest_cliffwrock",
        colorcube={
          boss="startingforest_owlitzermarket_boss_cc",
          entrance="startingforest_owlitzermarket_start_cc",
        },
        ground_shadow_strength=0.75,
        rimlightcolor="B3AAFFFF",
        rimlightpos={ 0.10000000149012, 40, 50,},
      },
      room_types={ "market", "metaunlock",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0.022633744855967, 0.40252983570099, 0.40253004431725, 0.74396133422852,},
            { 0.080246913580247, 0.34166491031647, 0.3560249209404, 0.5893719792366,},
            { 0.16255144032922, 0.22590959072113, 0.25478085875511, 0.42512077093124,},
            { 0.22222222222222, 0.14739809930325, 0.14614111185074, 0.29951691627502,},
            {
              0.32386363636364,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
          entrance={
            { 0.045267489711934, 0.50869745016098, 0.47291654348373, 0.71980679035187,},
            { 0.11522633744856, 0.38240495324135, 0.33468827605247, 0.66393446922302,},
            { 0.17901234567901, 0.21588236168027, 0.27588235810399, 0.45274511426687,},
            { 0.22916666666667, 0.1294117718935, 0.16470588743687, 0.3098039329052,},
            {
              0.32386363636364,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
        },
        prop_fade_color="000000FF",
      },
      water={  },
    },
  },
  lighting=nil,
  particle_systems={
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
        near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
        start_run={ easing="linear", likelihood={ from=1.0, to=1.0,},},
      },
      enabled=true,
      layer="backdrop",
      particle_system="stars",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=0.0, to=0.0,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0.0, to=0.0,},},
      },
      enabled=false,
      particle_system="fog_night_ground_projected",
    },
  },
  rooms={
    "owlforest_arena_esw",
    "owlforest_arena_ew",
    "owlforest_arena_nesw",
    "owlforest_arena_new",
    "owlforest_arena_nsw",
    "owlforest_arena_sw",
    "owlforest_small_esw",
    "owlforest_small_ew",
    "owlforest_small_nesw",
    "owlforest_small_new",
    "owlforest_small_nsw",
    "owlforest_small_nw",
    "owlforest_small_sw",
    "owlforest_start_e",
    "owlforest_start_n",
    "owlforest_start_ne",
    "owlforest_start_s",
    "owlforest_owlitzer_boss_s",
    "owlforest_owlitzer_hype_ns",
    "owlforest_2_arena_nw",
    "owlforest_miniboss_nesw",
    "owlforest_quest_nesw",
    "owlforest_large_nesw",
    "owlforest_4_arena_nw",
    "owlforest_arena_nw",
    "owlforest_market_nesw",
    "owlforest_metaunlock_nesw",
  },
  sky=nil,
  tier=2.0,
  tile_group="owlitzer_forest",
  underlay_props={  },
  water=nil,
  zone_gens={
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=18.0, hue=-47.0, saturation=-14.0,},
              likelihood=1.0,
              zones={ "near_bg",},
            },
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1.0,
              zones={ "near_bg",},
            },
            {
              color={ brightness=-1.0, hue=-28.0, saturation=-24.0,},
              likelihood=1.0,
              zones={ "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=0.80000001192093,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.80000001192093, count=5.0, height=0, radius=0.80000001192093,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="inSine", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.60000002384186, count=1, height=0, radius=0.60000002384186,},
          prop="forest_bg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1.0, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.85000002384186,},
          prop="forest_bg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.0, to=1.0,},},
            near_boss={ easing="inSine", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.85000002384186,},
          prop="forest_bg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.85000002384186,},
          prop="forest_bg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG1",
      zones={ "near_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: bg_trees",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-17.0, hue=15.0, saturation=5.0,},
              likelihood=100.0,
              zones={ "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=5.0, count=1, height=0, radius=0.80000001192093,},
          prop="forest_bg_smalltree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="bg_trees",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuad", likelihood={ from=0.0, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG2",
      zones={ "bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: bg_fill",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-19.0, hue=0, saturation=0,},
              likelihood=1.0,
              zones={ "bg",},
            },
            {
              color={ brightness=-12.0, hue=-38.0, saturation=-19.0,},
              likelihood=1.0,
              zones={ "bg",},
            },
            {
              color={ brightness=-7.0, hue=24.0, saturation=8.0,},
              likelihood=0.5,
              zones={ "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.64999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.80000001192093, count=5.0, height=0, radius=0.80000001192093,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=14.0, hue=3, saturation=-10,},
              likelihood=1.0,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="inSine", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1.0, height=0, radius=1.0,},
          prop="forest_bg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1.0, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1.0, height=0, radius=1.5,},
          prop="forest_bg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1.5,},
          prop="forest_bg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1.0, height=0, radius=1.6000000238419,},
          prop="forest_bg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="bg_trees",
      spacers={  },
      tag="ZONE_GEN_TAG3",
      zones={ "bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: bg_fill_entrance_quest",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={ "entrance", "quest", "metaunlock",},
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-12, hue=-6, saturation=0,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.10000000149012, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=0.25, to=0.10000000149012,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1.0,},
          prop="forest_bg_ruins",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            { color={ brightness=-19, hue=0, saturation=0,}, likelihood=1, zones={ "bg",},},
            {
              color={ brightness=-12, hue=-38, saturation=-19,},
              likelihood=1,
              zones={ "bg",},
            },
            { color={ brightness=-7, hue=24, saturation=8,}, likelihood=0.5, zones={ "bg",},},
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.64999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=5, height=0, radius=1,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=18, hue=-7, saturation=-16,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="inSine", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1.0, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1.5,},
          prop="forest_bg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1.6000000238419,},
          prop="forest_bg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-19.0, hue=-6, saturation=-24.0,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.10000000149012, to=0.25,},},
            near_boss={ easing="inSine", likelihood={ from=0.25, to=0.25,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.10000000149012,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_bg_ruins_dark",
          placement={ buffer=1, count=2.0, height=0, radius=1,},
          prop="forest_bg_ruins",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="bg_trees",
      spacers={  },
      tag="ZONE_GEN_TAG4",
      zones={ "bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: distant_bg_trees",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=5.0, count=1, height=0, radius=0.5,},
          prop="forest_bg_smalltree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="distant_bg_trees",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuad", likelihood={ from=0, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG5",
      zones={ "distant_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: distant_bg_fill",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=31.0, hue=0, saturation=23.0,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
            {
              color={ brightness=30.0, hue=27.0, saturation=7.0,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
            {
              color={ brightness=31.0, hue=-38.0, saturation=-31.0,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.64999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.80000001192093, count=8.0, height=0.0, radius=0.80000001192093,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=18, hue=-7, saturation=-16,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="inSine", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=37.0, hue=20.0, saturation=-7.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1.0, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=2.0, height=0, radius=0.80000001192093,},
          prop="forest_bg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=25, hue=-25, saturation=-7,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1.0, height=0, radius=0.80000001192093,},
          prop="forest_bg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=25, hue=-25, saturation=-7,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1.0, height=0, radius=0.80000001192093,},
          prop="forest_bg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.30000001192093, to=0.30000001192093,},},
            near_boss={ easing="linear", likelihood={ from=0.30000001192093, to=0.30000001192093,},},
            start_run={ easing="linear", likelihood={ from=0.30000001192093, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.25,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="distant_bg_trees",
      spacers={  },
      tag="ZONE_GEN_TAG6",
      zones={ "distant_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=61.0, hue=19.0, saturation=2.0,},
              likelihood=1,
              zones={ "distant_bg",},
            },
            {
              color={ brightness=48.0, hue=-5.0, saturation=-7.0,},
              likelihood=1,
              zones={ "distant_bg",},
            },
            {
              color={ brightness=70.0, hue=-55.0, saturation=-38.0,},
              likelihood=1,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.0,},},
            near_boss={ easing="linear", likelihood={ from=0.0, to=0.0,},},
            start_run={ easing="inQuad", likelihood={ from=1.0, to=0.5,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.89999997615814, count=1.0, height=0, radius=0.80000001192093,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=21.0, hue=11.0, saturation=-38.0,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.050000000745058, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuad", likelihood={ from=0.20000000298023, to=0.050000000745058,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=-0.5, radius=1,},
          prop="forest_bg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=38, hue=-167.0, saturation=29,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "unique", "centered", "required",},
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_bg_fillshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuad", likelihood={ from=0, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG7",
      zones={ "near_underlay",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={ { color={ brightness=8, hue=32, saturation=-22,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuad", likelihood={ from=0.0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=1, height=0, radius=1.0,},
          prop="forest_bg_farsmalltree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.0,},},
            near_boss={ easing="linear", likelihood={ from=0.0, to=0.0,},},
            start_run={ easing="inQuad", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=3.0, count=1, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG8",
      zones={ "underlay",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: side_trees",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-25.0, hue=7.0, saturation=8.0,},
              likelihood=100,
              zones={ "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=4.0, count=1, height=0, radius=1,},
          prop="forest_bg_smalltree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="side_trees",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG9",
      zones={ "side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="side_fill_entrance_quest",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={ "entrance", "quest", "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-28, hue=23, saturation=-9,},
              likelihood=1,
              zones={ "side",},
            },
            {
              color={ brightness=-29, hue=106, saturation=-27,},
              likelihood=1,
              zones={ "side",},
            },
            {
              color={ brightness=-22, hue=44, saturation=-16,},
              likelihood=1,
              zones={ "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.64999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=5, height=0, radius=1,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={
            {
              color={ brightness=18, hue=-7, saturation=-16,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="inSine", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_bg_grass",
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1.0, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2, height=0, radius=1.5,},
          prop="forest_bg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-12, hue=-6, saturation=0,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.10000000149012, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=0.25, to=0.10000000149012,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1.0,},
          prop="forest_bg_ruins",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-26, hue=-6, saturation=-29,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.10000000149012, to=0.25,},},
            near_boss={ easing="inSine", likelihood={ from=0.25, to=0.25,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.10000000149012,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_bg_ruins_dark",
          placement={ buffer=2.0, count=1, height=0, radius=2.0,},
          prop="forest_bg_ruins",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          prop="forest_bg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1.5,},
          prop="forest_bg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="side_trees",
      spacers={
        {
          buffer=0,
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG10",
      zones={ "side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-12.0, hue=51.0, saturation=0,},
              likelihood=1,
              zones={ "near_bg",},
            },
            { color={ brightness=0, hue=0, saturation=0,}, likelihood=1, zones={ "near_bg",},},
            {
              color={ brightness=17.0, hue=15.0, saturation=16.0,},
              likelihood=1,
              zones={ "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.25,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.89999997615814, count=6.0, height=0, radius=1.0,},
          prop="forest_bg_shrublower",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-9.0, hue=-11.0, saturation=-14.0,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="inSine", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1.0, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=2.0, height=0, radius=1.2000000476837,},
          prop="forest_bg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1.0, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=1.0, height=0, radius=1.5,},
          prop="forest_bg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=1.0, height=0, radius=1.5,},
          prop="forest_bg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=1.0, height=0, radius=1.5,},
          prop="forest_bg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG11",
      zones={ "near_side", "side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-12, hue=51, saturation=0,},
              likelihood=1,
              zones={ "near_bg",},
            },
            { color={ brightness=0, hue=0, saturation=0,}, likelihood=1, zones={ "near_bg",},},
            {
              color={ brightness=17, hue=15, saturation=16,},
              likelihood=1,
              zones={ "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.25,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=6.0, height=0.0, radius=1.7000000476837,},
          prop="forest_bg_shrublower",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-9, hue=-11, saturation=-14,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2, height=0, radius=1.2999999523163,},
          prop="forest_bg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          prop="forest_bg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          prop="forest_bg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          prop="forest_bg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG12",
      zones={ "side_inlet",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=false,
      fxes={  },
      name="Ground: side_fill",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "empty",
        "boss",
        "market",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={
            {
              color={ brightness=-28, hue=23, saturation=-9,},
              likelihood=1.0,
              zones={ "side",},
            },
            {
              color={ brightness=-29, hue=106, saturation=-27,},
              likelihood=1.0,
              zones={ "side",},
            },
            {
              color={ brightness=-22, hue=44, saturation=-16,},
              likelihood=1.0,
              zones={ "side",},
            },
          },
          count=5.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.64999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_bg_shrub",
          radius=1.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={
            {
              color={ brightness=18, hue=-7, saturation=-16,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="inSine", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_bg_grass",
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={  },
          count=2.0,
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1.0, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_bg_rock",
          radius=1.5,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          count=1.0,
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_bg_bossrock",
          radius=1.5,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0.5,
          color_variants={  },
          count=1.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_bg_owlrock",
          radius=1.5,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="side_trees",
      spacers={
        {
          buffer=0,
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG13",
      zones={ "side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: distant_side_trees",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-31.0, hue=-11.0, saturation=11.0,},
              likelihood=100,
              zones={ "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.5, count=1, height=0, radius=1,},
          prop="forest_bg_smalltree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="distant_side_trees",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG14",
      zones={ "distant_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: distant_side_fill, side_inlet2",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-33, hue=10, saturation=-11,},
              likelihood=1.0,
              zones={ "distant_side",},
            },
            {
              color={ brightness=-41.0, hue=37.0, saturation=-9.0,},
              likelihood=1.0,
              zones={ "distant_side",},
            },
            {
              color={ brightness=-43, hue=167, saturation=-9,},
              likelihood=1.0,
              zones={ "distant_side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.64999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.89999997615814, count=5, height=0, radius=0.80000001192093,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-14.0, hue=-17.0, saturation=-23.0,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="inSine", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=3.0, height=0, radius=1.0,},
          prop="forest_bg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=1.0, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=1.5,},
          prop="forest_bg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          count=1.0,
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_bg_bossrock",
          radius=1.5,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0.5,
          color_variants={  },
          count=1.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_bg_owlrock",
          radius=1.5,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="distant_side_trees",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG15",
      zones={ "distant_side", "side_inlet_two",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1.0,},
          prop="forest_fg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "near_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=1.0, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=3.0, height=0, radius=1.3999999761581,},
          prop="forest_fg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=0.5, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=2.2000000476837,},
          prop="forest_fg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=1,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="forest_fg_bossrock",
          radius=2.2000000476837,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=2.2000000476837,},
          prop="forest_fg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG16",
      zones={ "near_fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1.0,},
          prop="forest_fg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            { color={ brightness=-33, hue=-8, saturation=-22,}, likelihood=1, zones={ "fg",},},
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.2000000476837, count=3.0, height=0, radius=0.80000001192093,},
          prop="forest_fg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-12, hue=0, saturation=-4,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=0.5, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.6000000238419, count=1, height=0, radius=1.5,},
          prop="forest_fg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-12, hue=0, saturation=-4.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.6000000238419, count=1, height=0, radius=1.5,},
          prop="forest_fg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-12, hue=0, saturation=-4,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.6000000238419, count=1, height=0, radius=1.5,},
          prop="forest_fg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG17",
      zones={ "fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-33.0, hue=-8.0, saturation=-22.0,},
              likelihood=1.0,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1.0, height=0, radius=1.0,},
          prop="forest_fg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-33.0, hue=-8.0, saturation=-22.0,},
              likelihood=1.0,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=3.0, height=0, radius=1.5,},
          prop="forest_fg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-51.0, hue=-38.0, saturation=-11.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=0.5, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=1.0,},
          prop="forest_fg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-51, hue=-38, saturation=-11,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=1.0,},
          prop="forest_fg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-51, hue=-38, saturation=-11,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=1.0,},
          prop="forest_fg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG18",
      zones={ "distant_fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: fg_side - tree",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "required",},
          placement={ buffer=3.0, count=1, height=0, radius=1.0,},
          prop="forest_fg_tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG19",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: fg_side - fill",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-33, hue=-8, saturation=-22,},
              likelihood=1,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=0.60000002384186,},
          prop="forest_fg_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-33.0, hue=-8.0, saturation=-22.0,}, likelihood=1.0,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.89999997615814, to=0.75,},},
            near_boss={ easing="linear", likelihood={ from=0.75, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.89999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1.0,},
          prop="forest_fg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-34, hue=0, saturation=-11,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="outExpo", likelihood={ from=0.5, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=2.2000000476837,},
          prop="forest_fg_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-34, hue=0, saturation=-11,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.5,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=2.2000000476837,},
          prop="forest_fg_bossrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-34, hue=0, saturation=-11,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=2.2000000476837,},
          prop="forest_fg_owlrock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG20",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Physics: non_walkable_bg",
      non_walkable=true,
      offstage=false,
      particle_systems={  },
      room_types={ "boss", "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.2000000476837, count=1, height=0, radius=0.80000001192093,},
          prop="forest_grid_tree_owl",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="nodouble",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0.5, count=5.0, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=1.0, count=2.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG21",
      zones={ "non_walkable_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Physics: non_walkable_bg_fg",
      non_walkable=true,
      offstage=false,
      particle_systems={  },
      room_types={ "boss", "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=9.0, height=0, radius=0.15000000596046,},
          prop="forest_grid_tallgrass_owl",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-2, hue=-27, saturation=30.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=6.0, height=0, radius=0.15000000596046,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.75, count=1, height=0, radius=0.5,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.75, count=1, height=0, radius=0.5,},
          prop="flower_coralbell",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1.0, height=0, radius=0.75,},
          prop="forest_grid_berryshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="nodouble",
      spacers={  },
      tag="ZONE_GEN_TAG22",
      zones={ "non_walkable_fg", "non_walkable_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=false,
      fxes={  },
      name="inside_perimeter_arena_TREE",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "tall",},
          placement={ buffer=1.25, count=1, height=0, radius=0.75,},
          prop="forest_grid_tree_owl",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=2, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG23",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_arena",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=4.0, height=0, radius=1,},
          prop="forest_grid_berryshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          prop="flower_coralbell",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={ { color={ brightness=-2, hue=-27, saturation=30.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=8.0, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=2.0, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG24",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_entrance_quest_tree",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance", "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=2.0, height=0, radius=1.0,},
          prop="forest_grid_tree_owl",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="entrance_tree",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=7.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG25",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_entrance_quest_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance", "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2, height=0, radius=1,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=3, height=0, radius=1,},
          prop="flower_coralbell",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=4, height=0, radius=1,},
          prop="forest_grid_berryshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_rock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_rock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_owlrock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_owlrock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="entrance_tree",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=4.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=4.0, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG26",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_quest_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=3.0, height=0, radius=1,},
          prop="flower_coralbell",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=4.0, height=0, radius=1,},
          prop="forest_grid_berryshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_rock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_rock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_owlrock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0.5, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_owlrock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="entrance_tree",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG27",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="front_perimeter_arena",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "insert", "miniboss", "empty", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          prop="forest_grid_berryshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          prop="flower_coralbell",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={ { color={ brightness=-2, hue=-27, saturation=30.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=6.0, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG28",
      zones={ "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="front_perimeter_entrance_quest",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance", "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="flower_coralbell",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          prop="forest_grid_berryshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG29",
      zones={ "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_entrance_rock",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1.0, height=0, radius=1,},
          prop="destructible_rock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1.0, height=0, radius=1,},
          prop="destructible_rock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.0, to=0.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=0.0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_owlrock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_owlrock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="middle_entrance_rock",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=4.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG30",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_quest_rock",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_rock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_rock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_owlrock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_owlrock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="middle_entrance_rock",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=4,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=3.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG31",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_entrance_quest_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance", "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="middle_entrance_tree",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6.0, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=7.0, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          buffer=0,
          count=5,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG32",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_arena",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "boss", "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={ { color={ brightness=-2, hue=-27, saturation=30,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=1.0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=5.0, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.89200001955032,},},
            near_boss={ easing="linear", likelihood={ from=0.89300000667572, to=1,},},
            start_run={ easing="linear", likelihood={ from=0.5, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={  },
          count=2.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="spawner_plant1_med",
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="spawner_plant1_sml",
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=10.0, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=10.0, height=0, radius=1.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=4,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG33",
      zones={ "middle",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_tall",
          placement={ buffer=1.0, count=1, height=1.0, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_eventaller",
          placement={ buffer=1.0, count=1, height=4.0, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG34",
      zones={ "near_bg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="outSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_tall",
          placement={ buffer=1.0, count=1, height=1, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="outSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_eventaller",
          placement={ buffer=1.0, count=1, height=4.0, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG35",
      zones={ "side", "distant_side",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={ { color={ brightness=21.0, hue=0, saturation=-12.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1.0,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=21, hue=0, saturation=-12,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="outSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_taller",
          placement={ buffer=1.0, count=1, height=3.5, radius=1.0,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG36",
      zones={ "bg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="outSine", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="outSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_fg_canopy_higher",
          placement={ buffer=1.0, count=1, height=3.0, radius=0.5,},
          prop="forest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="outSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_fg_canopy_higher2",
          placement={ buffer=1.0, count=1, height=6.0, radius=1,},
          prop="forest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG37",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=true,
      decor_layer="Shadow",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="outSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inBack", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=5, count=1, height=0, radius=2.0,},
          prop="canopy_shadow",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.5,},},
            near_boss={ easing="outSine", likelihood={ from=0.5, to=0.25,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=3.0, count=3.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG38",
      zones={ "near_side", "near_bg", "near_fg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Shadow",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0.0,},},
            start_run={ easing="inBack", likelihood={ from=1.0, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=1, height=0, radius=1.0,},
          prop="canopy_shadow",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.5,},},
            near_boss={ easing="outSine", likelihood={ from=0.5, to=0.25,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=3.0, count=5.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG39",
      zones={ "front_perimeter", "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="FOG",
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "unique", "centered",},
          particle_system="fog_night_ground_projected",
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "food",
        "market",
        "mystery",
        "potion",
        "powerupgrade",
        "quest",
        "ranger",
        "resource",
        "wanderer",
        "metaunlock",
      },
      scene_props={  },
      spacers={  },
      tag="ZONE_GEN_TAG40",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_metaunlock",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={ { color={ brightness=-2, hue=-27, saturation=30,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=8, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=2, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG41",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="front_perimeter_metaunlock",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={ { color={ brightness=-2, hue=-27, saturation=30,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=6, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG42",
      zones={ "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_metaunlock_destructible",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=2.0, height=0, radius=1,},
          prop="destructible_rock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1.0, height=0, radius=1,},
          prop="destructible_rock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1,},
          prop="destructible_owlrock_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1.0, height=0, radius=1,},
          prop="destructible_owlrock_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-2, hue=-27, saturation=30,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=5.0, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
        },
      },
      seed="middle_entrance_rock",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=2.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6.0, height=0, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG43",
      zones={ "middle",},
    },
  },
}
t.lighting = t.environments[1].lighting
t.sky = t.environments[1].sky
t.water = t.environments[1].water
return t
